/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Alias;
import nxt.Attachment;
import nxt.NxtException;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONStreamAware;

public final class SellAlias
extends CreateTransaction {
    static final SellAlias instance = new SellAlias();

    private SellAlias() {
        super(new APITag[]{APITag.ALIASES, APITag.CREATE_TRANSACTION}, "alias", "aliasName", "recipient", "priceNQT");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Alias alias = ParameterParser.getAlias(httpServletRequest);
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        long l = ParameterParser.getLong(httpServletRequest, "priceNQT", 0L, 100000000000000000L, true);
        String string = Convert.emptyToNull(httpServletRequest.getParameter("recipient"));
        long l2 = 0L;
        if (string != null) {
            try {
                l2 = Convert.parseAccountId(string);
            }
            catch (RuntimeException runtimeException) {
                return JSONResponses.INCORRECT_RECIPIENT;
            }
            if (l2 == 0L) {
                return JSONResponses.INCORRECT_RECIPIENT;
            }
        }
        if (alias.getAccountId() != account.getId()) {
            return JSONResponses.INCORRECT_ALIAS_OWNER;
        }
        Attachment.MessagingAliasSell messagingAliasSell = new Attachment.MessagingAliasSell(alias.getAliasName(), l);
        return this.createTransaction(httpServletRequest, account, l2, 0L, messagingAliasSell);
    }
}

