/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.Transaction;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.peer.Peers;
import nxt.util.Convert;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class SendTransaction
extends APIServlet.APIRequestHandler {
    static final SendTransaction instance = new SendTransaction();

    private SendTransaction() {
        super(new APITag[]{APITag.TRANSACTIONS}, "transactionJSON", "transactionBytes", "prunableAttachmentJSON");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        String string = Convert.emptyToNull(httpServletRequest.getParameter("transactionJSON"));
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter("transactionBytes"));
        String string3 = Convert.emptyToNull(httpServletRequest.getParameter("prunableAttachmentJSON"));
        JSONObject jSONObject = new JSONObject();
        try {
            Transaction.Builder builder = ParameterParser.parseTransaction(string, string2, string3);
            Transaction transaction = builder.build();
            Peers.sendToSomePeers(Collections.singletonList(transaction));
            jSONObject.put("transaction", transaction.getStringId());
            jSONObject.put("fullHash", transaction.getFullHash());
        }
        catch (RuntimeException | NxtException.ValidationException exception) {
            JSONData.putException(jSONObject, exception, "Failed to broadcast transaction");
        }
        return jSONObject;
    }

    @Override
    protected boolean requirePost() {
        return true;
    }

    @Override
    protected boolean requirePassword() {
        return true;
    }

    @Override
    protected boolean requireBlockchain() {
        return false;
    }

    @Override
    protected final boolean allowRequiredBlockParameters() {
        return false;
    }
}

