/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Alias;
import nxt.Attachment;
import nxt.NxtException;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class SetAlias
extends CreateTransaction {
    static final SetAlias instance = new SetAlias();

    private SetAlias() {
        super(new APITag[]{APITag.ALIASES, APITag.CREATE_TRANSACTION}, "aliasName", "aliasURI");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        String string = Convert.emptyToNull(httpServletRequest.getParameter("aliasName"));
        String string2 = Convert.nullToEmpty(httpServletRequest.getParameter("aliasURI"));
        if (string == null) {
            return JSONResponses.MISSING_ALIAS_NAME;
        }
        if ((string = string.trim()).length() == 0 || string.length() > 100) {
            return JSONResponses.INCORRECT_ALIAS_LENGTH;
        }
        String string3 = string.toLowerCase(Locale.ROOT);
        for (int i = 0; i < string3.length(); ++i) {
            if ("0123456789abcdefghijklmnopqrstuvwxyz".indexOf(string3.charAt(i)) >= 0) continue;
            return JSONResponses.INCORRECT_ALIAS_NAME;
        }
        if ((string2 = string2.trim()).length() > 1000) {
            return JSONResponses.INCORRECT_URI_LENGTH;
        }
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        Alias alias = Alias.getAlias(string3);
        if (alias != null && alias.getAccountId() != account.getId()) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("errorCode", 8);
            jSONObject.put("errorDescription", "\"" + string + "\" is already used");
            return jSONObject;
        }
        Attachment.MessagingAliasAssignment messagingAliasAssignment = new Attachment.MessagingAliasAssignment(string, string2);
        return this.createTransaction(httpServletRequest, account, messagingAliasAssignment);
    }
}

