/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Attachment;
import nxt.NxtException;
import nxt.Shuffling;
import nxt.ShufflingParticipant;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import nxt.util.JSON;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class ShufflingProcess
extends CreateTransaction {
    static final ShufflingProcess instance = new ShufflingProcess();

    private ShufflingProcess() {
        super(new APITag[]{APITag.SHUFFLING, APITag.CREATE_TRANSACTION}, "shuffling", "recipientSecretPhrase", "recipientPublicKey");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Shuffling shuffling = ParameterParser.getShuffling(httpServletRequest);
        if (shuffling.getStage() != Shuffling.Stage.PROCESSING) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("errorCode", 11);
            jSONObject.put("errorDescription", "Shuffling is not in processing, stage " + shuffling.getStage());
            return JSON.prepare(jSONObject);
        }
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        long l = account.getId();
        if (shuffling.getAssigneeAccountId() != l) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("errorCode", 12);
            jSONObject.put("errorDescription", String.format("Account %s cannot process shuffling since shuffling assignee is %s", Convert.rsAccount(l), Convert.rsAccount(shuffling.getAssigneeAccountId())));
            return JSON.prepare(jSONObject);
        }
        ShufflingParticipant shufflingParticipant = shuffling.getParticipant(l);
        if (shufflingParticipant == null) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("errorCode", 13);
            jSONObject.put("errorDescription", String.format("Account %s is not a participant of shuffling %d", Convert.rsAccount(l), shuffling.getId()));
            return JSON.prepare(jSONObject);
        }
        String string = ParameterParser.getSecretPhrase(httpServletRequest, true);
        byte[] byArray = ParameterParser.getPublicKey(httpServletRequest, "recipient");
        if (Account.getAccount(byArray) != null) {
            return JSONResponses.INCORRECT_PUBLIC_KEY;
        }
        Attachment.ShufflingAttachment shufflingAttachment = shuffling.process(l, string, byArray);
        return this.createTransaction(httpServletRequest, account, shufflingAttachment);
    }
}

