/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Asset;
import nxt.Currency;
import nxt.FundingMonitor;
import nxt.HoldingType;
import nxt.NxtException;
import nxt.crypto.Crypto;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class StartFundingMonitor
extends APIServlet.APIRequestHandler {
    static final StartFundingMonitor instance = new StartFundingMonitor();

    private StartFundingMonitor() {
        super(new APITag[]{APITag.ACCOUNTS}, "holdingType", "holding", "property", "amount", "threshold", "interval", "secretPhrase");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Object object;
        Object object2;
        HoldingType holdingType = ParameterParser.getHoldingType(httpServletRequest);
        long l = ParameterParser.getHoldingId(httpServletRequest, holdingType);
        String string = ParameterParser.getAccountProperty(httpServletRequest, true);
        long l2 = ParameterParser.getLong(httpServletRequest, "amount", 0L, Long.MAX_VALUE, true);
        if (l2 < 1L) {
            throw new ParameterException(JSONResponses.incorrect("amount", "Minimum funding amount is 1"));
        }
        long l3 = ParameterParser.getLong(httpServletRequest, "threshold", 0L, Long.MAX_VALUE, true);
        if (l3 < 1L) {
            throw new ParameterException(JSONResponses.incorrect("threshold", "Minimum funding threshold is 1"));
        }
        int n = ParameterParser.getInt(httpServletRequest, "interval", 10, Integer.MAX_VALUE, true);
        String string2 = ParameterParser.getSecretPhrase(httpServletRequest, true);
        switch (holdingType) {
            case ASSET: {
                object2 = Asset.getAsset(l);
                if (object2 != null) break;
                throw new ParameterException(JSONResponses.UNKNOWN_ASSET);
            }
            case CURRENCY: {
                object = Currency.getCurrency(l);
                if (object != null) break;
                throw new ParameterException(JSONResponses.UNKNOWN_CURRENCY);
            }
        }
        object2 = Account.getAccount(Crypto.getPublicKey(string2));
        if (object2 == null) {
            throw new ParameterException(JSONResponses.UNKNOWN_ACCOUNT);
        }
        if (((Account)object2).getControls().contains((Object)Account.ControlType.PHASING_ONLY)) {
            return JSONResponses.error("Accounts under phasing only control cannot run a funding monitor");
        }
        if (FundingMonitor.startMonitor(holdingType, l, string, l2, l3, n, string2)) {
            object = new JSONObject();
            ((HashMap)object).put("started", true);
            return object;
        }
        return JSONResponses.MONITOR_ALREADY_STARTED;
    }

    @Override
    protected boolean requirePost() {
        return true;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireFullClient() {
        return true;
    }
}

