/*
 * Decompiled with CFR 0.152.
 */
package nxt.peer;

import java.util.List;
import nxt.Nxt;
import nxt.peer.GetNextBlocks;
import nxt.peer.Peer;
import nxt.peer.PeerServlet;
import nxt.util.Convert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

final class GetNextBlockIds
extends PeerServlet.PeerRequestHandler {
    static final GetNextBlockIds instance = new GetNextBlockIds();

    private GetNextBlockIds() {
    }

    @Override
    JSONStreamAware processRequest(JSONObject jSONObject, Peer peer) {
        JSONObject jSONObject2 = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        long l2 = Convert.parseUnsignedLong((String)jSONObject.get("blockId"));
        int n = (int)Convert.parseLong(jSONObject.get("limit"));
        if (n > 1440) {
            return GetNextBlocks.TOO_MANY_BLOCKS_REQUESTED;
        }
        List<Long> list = Nxt.getBlockchain().getBlockIdsAfter(l2, n > 0 ? n : 1440);
        list.forEach(l -> jSONArray.add(Long.toUnsignedString(l)));
        jSONObject2.put("nextBlockIds", jSONArray);
        return jSONObject2;
    }

    @Override
    boolean rejectWhileDownloading() {
        return true;
    }
}

