/*
 * Decompiled with CFR 0.152.
 */
package nxt.peer;

import java.util.ArrayList;
import java.util.List;
import nxt.Block;
import nxt.Nxt;
import nxt.peer.Peer;
import nxt.peer.PeerServlet;
import nxt.util.Convert;
import nxt.util.JSON;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

final class GetNextBlocks
extends PeerServlet.PeerRequestHandler {
    static final GetNextBlocks instance = new GetNextBlocks();
    static final JSONStreamAware TOO_MANY_BLOCKS_REQUESTED;

    private GetNextBlocks() {
    }

    @Override
    JSONStreamAware processRequest(JSONObject jSONObject, Peer peer) {
        List<? extends Block> list;
        JSONObject jSONObject2 = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        long l = Convert.parseUnsignedLong((String)jSONObject.get("blockId"));
        List list2 = (List)jSONObject.get("blockIds");
        if (list2 != null) {
            if (list2.size() > 36) {
                return TOO_MANY_BLOCKS_REQUESTED;
            }
            ArrayList<Long> arrayList = new ArrayList<Long>();
            list2.forEach(string -> arrayList.add(Convert.parseUnsignedLong(string)));
            list = Nxt.getBlockchain().getBlocksAfter(l, arrayList);
        } else {
            long l2 = Convert.parseLong(jSONObject.get("limit"));
            if (l2 > 36L) {
                return TOO_MANY_BLOCKS_REQUESTED;
            }
            list = Nxt.getBlockchain().getBlocksAfter(l, l2 > 0L ? (int)l2 : 36);
        }
        list.forEach(block -> jSONArray.add(block.getJSONObject()));
        jSONObject2.put("nextBlocks", jSONArray);
        return jSONObject2;
    }

    @Override
    boolean rejectWhileDownloading() {
        return true;
    }

    static {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("error", "Too many blocks requested");
        TOO_MANY_BLOCKS_REQUESTED = JSON.prepare(jSONObject);
    }
}

