/*
 * Decompiled with CFR 0.152.
 */
package nxt.peer;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nxt.BlockchainProcessor;
import nxt.Constants;
import nxt.Nxt;
import nxt.peer.AddPeers;
import nxt.peer.GetCumulativeDifficulty;
import nxt.peer.GetInfo;
import nxt.peer.GetMilestoneBlockIds;
import nxt.peer.GetNextBlockIds;
import nxt.peer.GetNextBlocks;
import nxt.peer.GetPeers;
import nxt.peer.GetTransactions;
import nxt.peer.GetUnconfirmedTransactions;
import nxt.peer.Peer;
import nxt.peer.PeerImpl;
import nxt.peer.PeerWebSocket;
import nxt.peer.Peers;
import nxt.peer.ProcessBlock;
import nxt.peer.ProcessTransactions;
import nxt.util.CountingInputReader;
import nxt.util.CountingOutputWriter;
import nxt.util.JSON;
import nxt.util.Logger;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

public final class PeerServlet
extends WebSocketServlet {
    private static final Map<String, PeerRequestHandler> peerRequestHandlers;
    static final JSONStreamAware UNSUPPORTED_REQUEST_TYPE;
    private static final JSONStreamAware UNSUPPORTED_PROTOCOL;
    private static final JSONStreamAware UNKNOWN_PEER;
    private static final JSONStreamAware SEQUENCE_ERROR;
    private static final JSONStreamAware MAX_INBOUND_CONNECTIONS;
    private static final JSONStreamAware DOWNLOADING;
    private static final JSONStreamAware LIGHT_CLIENT;
    private static final BlockchainProcessor blockchainProcessor;

    static JSONStreamAware error(Exception exception) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("error", Peers.hideErrorDetails ? exception.getClass().getName() : exception.toString());
        return jSONObject;
    }

    public void configure(WebSocketServletFactory webSocketServletFactory) {
        webSocketServletFactory.getPolicy().setIdleTimeout((long)Peers.webSocketIdleTimeout);
        webSocketServletFactory.getPolicy().setMaxBinaryMessageSize(Peers.MAX_MESSAGE_SIZE);
        webSocketServletFactory.setCreator((WebSocketCreator)new PeerSocketCreator());
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        PeerImpl peerImpl = Peers.findOrCreatePeer(httpServletRequest.getRemoteAddr());
        JSONStreamAware jSONStreamAware = peerImpl == null ? UNKNOWN_PEER : this.process(peerImpl, httpServletRequest.getReader());
        httpServletResponse.setContentType("text/plain; charset=UTF-8");
        try (CountingOutputWriter countingOutputWriter = new CountingOutputWriter(httpServletResponse.getWriter());){
            JSON.writeJSONString(jSONStreamAware, countingOutputWriter);
            if (peerImpl != null) {
                peerImpl.updateUploadedVolume(countingOutputWriter.getCount());
            }
        }
        catch (IOException | RuntimeException exception) {
            if (peerImpl != null) {
                if ((Peers.communicationLoggingMask & 1) != 0) {
                    if (exception instanceof RuntimeException) {
                        Logger.logDebugMessage("Error sending response to peer " + peerImpl.getHost(), exception);
                    } else {
                        Logger.logDebugMessage(String.format("Error sending response to peer %s: %s", peerImpl.getHost(), exception.getMessage() != null ? exception.getMessage() : exception.toString()));
                    }
                }
                peerImpl.blacklist(exception);
            }
            throw exception;
        }
    }

    void doPost(PeerWebSocket peerWebSocket, long l, String string) {
        block9: {
            JSONStreamAware jSONStreamAware;
            InetSocketAddress inetSocketAddress = peerWebSocket.getRemoteAddress();
            if (inetSocketAddress == null) {
                return;
            }
            String string2 = inetSocketAddress.getHostString();
            PeerImpl peerImpl = Peers.findOrCreatePeer(string2);
            if (peerImpl == null) {
                jSONStreamAware = UNKNOWN_PEER;
            } else {
                peerImpl.setInboundWebSocket(peerWebSocket);
                jSONStreamAware = this.process(peerImpl, new StringReader(string));
            }
            try {
                StringWriter stringWriter = new StringWriter(1000);
                JSON.writeJSONString(jSONStreamAware, stringWriter);
                String string3 = stringWriter.toString();
                peerWebSocket.sendResponse(l, string3);
                if (peerImpl != null) {
                    peerImpl.updateUploadedVolume(string3.length());
                }
            }
            catch (IOException | RuntimeException exception) {
                if (peerImpl == null) break block9;
                if ((Peers.communicationLoggingMask & 1) != 0) {
                    if (exception instanceof RuntimeException) {
                        Logger.logDebugMessage("Error sending response to peer " + peerImpl.getHost(), exception);
                    } else {
                        Logger.logDebugMessage(String.format("Error sending response to peer %s: %s", peerImpl.getHost(), exception.getMessage() != null ? exception.getMessage() : exception.toString()));
                    }
                }
                peerImpl.blacklist(exception);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONStreamAware process(PeerImpl peerImpl, Reader reader) {
        if (peerImpl.isBlacklisted()) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("error", "Your peer is blacklisted");
            jSONObject.put("cause", peerImpl.getBlacklistingCause());
            return jSONObject;
        }
        if (Peers.getMorePeers) {
            Peers.addPeer(peerImpl);
        }
        try (CountingInputReader countingInputReader = new CountingInputReader(reader, Peers.MAX_REQUEST_SIZE);){
            JSONObject jSONObject = (JSONObject)JSONValue.parseWithException(countingInputReader);
            peerImpl.updateDownloadedVolume(countingInputReader.getCount());
            if (jSONObject.get("protocol") == null || ((Number)jSONObject.get("protocol")).intValue() != 1) {
                Logger.logDebugMessage("Unsupported protocol " + jSONObject.get("protocol"));
                JSONStreamAware jSONStreamAware = UNSUPPORTED_PROTOCOL;
                return jSONStreamAware;
            }
            PeerRequestHandler peerRequestHandler = peerRequestHandlers.get((String)jSONObject.get("requestType"));
            if (peerRequestHandler == null) {
                JSONStreamAware jSONStreamAware = UNSUPPORTED_REQUEST_TYPE;
                return jSONStreamAware;
            }
            if (peerImpl.getState() == Peer.State.DISCONNECTED) {
                peerImpl.setState(Peer.State.CONNECTED);
            }
            if (peerImpl.getVersion() == null && !"getInfo".equals(jSONObject.get("requestType"))) {
                JSONStreamAware jSONStreamAware = SEQUENCE_ERROR;
                return jSONStreamAware;
            }
            if (!peerImpl.isInbound()) {
                if (Peers.hasTooManyInboundPeers()) {
                    JSONStreamAware jSONStreamAware = MAX_INBOUND_CONNECTIONS;
                    return jSONStreamAware;
                }
                Peers.notifyListeners(peerImpl, Peers.Event.ADD_INBOUND);
            }
            peerImpl.setLastInboundRequest(Nxt.getEpochTime());
            if (peerRequestHandler.rejectWhileDownloading()) {
                if (blockchainProcessor.isDownloading()) {
                    JSONStreamAware jSONStreamAware = DOWNLOADING;
                    return jSONStreamAware;
                }
                if (Constants.isLightClient) {
                    JSONStreamAware jSONStreamAware = LIGHT_CLIENT;
                    return jSONStreamAware;
                }
            }
            JSONStreamAware jSONStreamAware = peerRequestHandler.processRequest(jSONObject, peerImpl);
            return jSONStreamAware;
        }
        catch (IOException | RuntimeException | ParseException exception) {
            Logger.logDebugMessage("Error processing POST request: " + exception.toString());
            peerImpl.blacklist(exception);
            return PeerServlet.error(exception);
        }
    }

    static {
        JSONObject jSONObject = new HashMap();
        jSONObject.put("addPeers", AddPeers.instance);
        jSONObject.put("getCumulativeDifficulty", GetCumulativeDifficulty.instance);
        jSONObject.put("getInfo", GetInfo.instance);
        jSONObject.put("getMilestoneBlockIds", GetMilestoneBlockIds.instance);
        jSONObject.put("getNextBlockIds", GetNextBlockIds.instance);
        jSONObject.put("getNextBlocks", GetNextBlocks.instance);
        jSONObject.put("getPeers", GetPeers.instance);
        jSONObject.put("getTransactions", GetTransactions.instance);
        jSONObject.put("getUnconfirmedTransactions", GetUnconfirmedTransactions.instance);
        jSONObject.put("processBlock", ProcessBlock.instance);
        jSONObject.put("processTransactions", ProcessTransactions.instance);
        peerRequestHandlers = Collections.unmodifiableMap(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("error", "Unsupported request type!");
        UNSUPPORTED_REQUEST_TYPE = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("error", "Unsupported protocol!");
        UNSUPPORTED_PROTOCOL = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("error", "Your peer address cannot be resolved");
        UNKNOWN_PEER = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("error", "Peer request received before 'getInfo' request");
        SEQUENCE_ERROR = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("error", "Maximum number of inbound connections exceeded");
        MAX_INBOUND_CONNECTIONS = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("error", "Blockchain download in progress");
        DOWNLOADING = JSON.prepare(jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("error", "Peer is in light mode");
        LIGHT_CLIENT = JSON.prepare(jSONObject);
        blockchainProcessor = Nxt.getBlockchainProcessor();
    }

    private class PeerSocketCreator
    implements WebSocketCreator {
        private PeerSocketCreator() {
        }

        public Object createWebSocket(ServletUpgradeRequest servletUpgradeRequest, ServletUpgradeResponse servletUpgradeResponse) {
            return Peers.useWebSockets ? new PeerWebSocket(PeerServlet.this) : null;
        }
    }

    static abstract class PeerRequestHandler {
        PeerRequestHandler() {
        }

        abstract JSONStreamAware processRequest(JSONObject var1, Peer var2);

        abstract boolean rejectWhileDownloading();
    }
}

