/*
 * Decompiled with CFR 0.152.
 */
package nxt.peer;

import nxt.Block;
import nxt.Nxt;
import nxt.NxtException;
import nxt.peer.Peer;
import nxt.peer.PeerServlet;
import nxt.peer.Peers;
import nxt.util.Convert;
import nxt.util.JSON;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

final class ProcessBlock
extends PeerServlet.PeerRequestHandler {
    static final ProcessBlock instance = new ProcessBlock();

    private ProcessBlock() {
    }

    @Override
    JSONStreamAware processRequest(JSONObject jSONObject, Peer peer) {
        String string = (String)jSONObject.get("previousBlock");
        Block block = Nxt.getBlockchain().getLastBlock();
        if (block.getStringId().equals(string) || Convert.parseUnsignedLong(string) == block.getPreviousBlockId() && (long)block.getTimestamp() > Convert.parseLong(jSONObject.get("timestamp"))) {
            Peers.peersService.submit(() -> {
                block2: {
                    try {
                        Nxt.getBlockchainProcessor().processPeerBlock(jSONObject);
                    }
                    catch (RuntimeException | NxtException exception) {
                        if (peer == null) break block2;
                        peer.blacklist(exception);
                    }
                }
            });
        }
        return JSON.emptyJSON;
    }

    @Override
    boolean rejectWhileDownloading() {
        return true;
    }
}

